import {FC, memo, useEffect, useMemo} from 'react';

import {
    ETrainsFilterType,
    ITrainsFilters,
} from 'types/trains/search/filters/ITrainsFilters';
import {TTrainsFilterTypeAndValue} from 'types/trains/search/filters/TTrainsFilterTypeAndValue';
import {ETrainsGoal} from 'utilities/metrika/types/goals/trains';

import {reachGoal} from 'utilities/metrika';
import {IWithQaAttributes} from 'utilities/qaAttributes/qaAttributes';
import {checkCanRenderHighSpeedTrainFastFilter} from '../components/TrainsHighSpeedTrainFastFilter/utilities/checkCanRenderHighSpeedTrainFastFilter';

import Box from 'components/Box/Box';
import TrainsSearchPageMobileFastFiltersSkeleton from './components/TrainsSearchPageMobileFastFiltersSkeleton';
import TrainsHighSpeedTrainFastFilter from '../components/TrainsHighSpeedTrainFastFilter/TrainsHighSpeedTrainFastFilter';

import cx from './TrainsSearchPageMobileFastFilters.scss';

interface ITrainsSearchPageMobileFastFiltersProps extends IWithQaAttributes {
    filters: ITrainsFilters | null;
    hasPageLoader: boolean;
    searchIsFinished: boolean;
    onChangeFilterValue(typeAndValue: TTrainsFilterTypeAndValue): void;
}

const TrainsSearchPageMobileFastFilters: FC<ITrainsSearchPageMobileFastFiltersProps> =
    props => {
        const {filters, hasPageLoader, searchIsFinished, onChangeFilterValue} =
            props;
        const highSpeedTrainFilter =
            filters?.[ETrainsFilterType.HIGH_SPEED_TRAIN];

        const canRenderHighSpeedTrainFastFilter = useMemo(
            () => checkCanRenderHighSpeedTrainFastFilter(highSpeedTrainFilter),
            [highSpeedTrainFilter],
        );

        useEffect(() => {
            if (canRenderHighSpeedTrainFastFilter) {
                reachGoal(ETrainsGoal.FAST_FILTER_HIGH_SPEED_TRAIN_CAN_SHOW);
            }
        }, [canRenderHighSpeedTrainFastFilter]);

        if (hasPageLoader) {
            return <TrainsSearchPageMobileFastFiltersSkeleton />;
        }

        return (
            <Box below={2} className={cx('root')}>
                {highSpeedTrainFilter && (
                    <TrainsHighSpeedTrainFastFilter
                        filter={highSpeedTrainFilter}
                        onChange={onChangeFilterValue}
                        searchIsFinished={searchIsFinished}
                    />
                )}
            </Box>
        );
    };

export default memo(TrainsSearchPageMobileFastFilters);
