import {FC} from 'react';

import {IWithClassName} from 'types/withClassName';

import {IWithQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import Flex from 'components/Flex/Flex';
import ButtonSkeleton from 'components/Skeletons/ButtonSkeleton/ButtonSkeleton';

import cx from './TrainsSearchPageMobileFastFiltersSkeleton.scss';

interface ITrainsSearchPageMobileFastFiltersSkeletonProps
    extends IWithQaAttributes,
        IWithClassName {}

const TrainsSearchPageMobileFastFiltersSkeleton: FC<ITrainsSearchPageMobileFastFiltersSkeletonProps> =
    () => {
        return (
            <Flex flexDirection="row" inline between={2} below={2} nowrap>
                <ButtonSkeleton
                    className={cx('button')}
                    size="l"
                    withAnimation
                />
                <ButtonSkeleton
                    className={cx('button')}
                    size="l"
                    withAnimation
                />
            </Flex>
        );
    };

export default TrainsSearchPageMobileFastFiltersSkeleton;
