import {DELUXE_TRAIN_IDS} from 'projects/trains/constants/deluxeTrains';

import {
    ITrainsHighSpeedTrainFilter,
    ITrainsSimpleFilterOption,
} from 'types/trains/search/filters/ITrainsFilters';

const HIGH_SPEED_TRAIN_FAST_FILTER_IDS = [
    DELUXE_TRAIN_IDS.sapsan,
    DELUXE_TRAIN_IDS.lastochka,
];

export const getHighSpeedTrainFastFilterOptions = (
    filter?: ITrainsHighSpeedTrainFilter,
): ITrainsSimpleFilterOption[] => {
    if (!filter) {
        return [];
    }

    const {options} = filter;

    return options.filter(option =>
        HIGH_SPEED_TRAIN_FAST_FILTER_IDS.includes(parseInt(option.value, 10)),
    );
};
