import React from 'react';

import {TTrainsFilterTypeAndValue} from 'types/trains/search/filters/TTrainsFilterTypeAndValue';
import {
    ITrainsArrivalFilter,
    ITrainsDepartureFilter,
} from 'types/trains/search/filters/ITrainsFilters';

import * as i18nBlock from 'i18n/common-filters';

import Box from 'components/Box/Box';

import TrainsTimeFilter from '../TrainsTimeFilter/TrainsTimeFilter';

import cx from './TrainsDepartureAndArrivalTimeFilter.scss';

interface ITrainsDepartureAndArrivalTimeFilterProps {
    arrivalFilter: ITrainsArrivalFilter;
    departureFilter: ITrainsDepartureFilter;
    onChange(typeAndValue: TTrainsFilterTypeAndValue): void;
}

const TrainsDepartureAndArrivalTimeFilter: React.FC<ITrainsDepartureAndArrivalTimeFilterProps> =
    ({arrivalFilter, departureFilter, onChange}) => {
        const arrivalOptions = arrivalFilter.options;
        const departureOptions = departureFilter.options;

        return (
            <Box className={cx('popupWrapper')} between={7}>
                {departureOptions.length > 1 && (
                    <TrainsTimeFilter
                        title={i18nBlock.departure()}
                        filter={departureFilter}
                        onChange={onChange}
                    />
                )}
                {arrivalOptions.length > 1 && (
                    <TrainsTimeFilter
                        title={i18nBlock.arrival()}
                        filter={arrivalFilter}
                        onChange={onChange}
                    />
                )}
            </Box>
        );
    };

export default TrainsDepartureAndArrivalTimeFilter;
