import React from 'react';

import {ITrainsFilterOptionMinPrice} from 'types/trains/search/filters/ITrainsFilters';

import Text from 'components/Text/Text';
import Price from 'components/Price/Price';

interface ITrainsFilterOptionPriceProps {
    minPrice: ITrainsFilterOptionMinPrice;
}

const TrainsFilterOptionPrice: React.FC<ITrainsFilterOptionPriceProps> =
    props => {
        const {minPrice} = props;
        const {price, isMinPrice} = minPrice;

        if (!price) {
            return null;
        }

        return (
            <Text color={isMinPrice ? 'success' : 'primary'}>
                <Price isFrom isRound {...price} />
            </Text>
        );
    };

export default TrainsFilterOptionPrice;
