import React, {useCallback} from 'react';
import {useDispatch} from 'react-redux';

import {mapSearchFilterToClickGoal} from 'projects/trains/constants/metrika';

import {
    ETrainsFilterType,
    ITrainsHideWithoutPriceFilter,
} from 'types/trains/search/filters/ITrainsFilters';
import {IWithClassName} from 'types/withClassName';

import {setTrainsSearchFilterValue} from 'reducers/trains/genericSearch/filters/actions';

import {reachGoal} from 'utilities/metrika';

import * as i18nBlock from 'i18n/trains-filters';

import Checkbox from 'components/Checkbox/Checkbox';

interface ITrainsSearchPageHideWithoutPriceFilterProps extends IWithClassName {
    filter: ITrainsHideWithoutPriceFilter;
}

const TrainsHideWithoutPriceFilter: React.FC<ITrainsSearchPageHideWithoutPriceFilterProps> =
    props => {
        const dispatch = useDispatch();
        const {filter, className} = props;
        const {value: filterValue, options, activeOptions} = filter;

        const handleChangeFilterValue = useCallback(() => {
            reachGoal(
                mapSearchFilterToClickGoal[
                    ETrainsFilterType.HIDE_WITHOUT_PRICE
                ],
            );

            dispatch(
                setTrainsSearchFilterValue({
                    type: ETrainsFilterType.HIDE_WITHOUT_PRICE,
                    value: !filterValue,
                }),
            );
        }, [dispatch, filterValue]);

        if (!options.withoutPrice) {
            return null;
        }

        return (
            <Checkbox
                className={className}
                size="s"
                label={i18nBlock.hideWithoutPriceDashOption()}
                checked={filterValue}
                disabled={!activeOptions.withoutPrice && !filterValue}
                onChange={handleChangeFilterValue}
            />
        );
    };

export default TrainsHideWithoutPriceFilter;
