import React, {useCallback, useMemo} from 'react';

import {
    ETrainsFilterType,
    ITrainsPriceRangeFilter,
} from 'types/trains/search/filters/ITrainsFilters';
import {IWithClassName} from 'types/withClassName';
import {TTrainsFilterTypeAndValue} from 'types/trains/search/filters/TTrainsFilterTypeAndValue';

import CommonPriceFilter from 'components/PriceFilter/PriceFilter';

interface ITrainsPriceFilterProps extends IWithClassName {
    filter: ITrainsPriceRangeFilter;
    onChange(typeAndValue: TTrainsFilterTypeAndValue): void;
}

const TrainsPriceFilter: React.FC<ITrainsPriceFilterProps> = ({
    className,
    filter,
    onChange,
}) => {
    const rangeValues = useMemo((): [number, number] => {
        const {min} = filter.options[0];
        const {max} = filter.options[filter.options.length - 1];

        return [min, max];
    }, [filter]);

    const values = useMemo((): [number, number] => {
        const selectedValue = filter.value[0];

        if (selectedValue) {
            return [selectedValue.min, selectedValue.max];
        }

        return rangeValues;
    }, [filter, rangeValues]);

    const handlePriceFilterChange = useCallback(
        ([min, max]: [number, number]) => {
            onChange({
                type: ETrainsFilterType.PRICE_RANGE,
                value: [{min, max}],
            });
        },
        [onChange],
    );

    return (
        <CommonPriceFilter
            className={className}
            values={values}
            rangeValues={rangeValues}
            onChange={handlePriceFilterChange}
        />
    );
};

export default TrainsPriceFilter;
