import React from 'react';

import {TTrainsFilterTypeAndValue} from 'types/trains/search/filters/TTrainsFilterTypeAndValue';
import {
    ITrainsStationFromFilter,
    ITrainsStationToFilter,
} from 'types/trains/search/filters/ITrainsFilters';

import * as i18nBlock from 'i18n/common-filters';

import Box from 'components/Box/Box';

import TrainsStationFilter from '../TrainsStationFilter/TrainsStationFilter';

import cx from './TrainsStationFromAndStationToFilter.scss';

interface ITrainsStationFromAndStationToFilterProps {
    stationFromFilter: ITrainsStationFromFilter;
    stationToFilter: ITrainsStationToFilter;
    onChange(typeAndValue: TTrainsFilterTypeAndValue): void;
}

const TrainsStationFromAndStationToFilter: React.FC<ITrainsStationFromAndStationToFilterProps> =
    ({stationFromFilter, stationToFilter, onChange}) => {
        const departureOptions = stationFromFilter.options;
        const arrivalOptions = stationToFilter.options;

        return (
            <Box className={cx('popupWrapper')} between={7}>
                {departureOptions.length > 1 && (
                    <Box between={3}>
                        <Box textSize="m" textWeight="bold">
                            {i18nBlock.departure()}
                        </Box>
                        <TrainsStationFilter
                            filter={stationFromFilter}
                            onChange={onChange}
                        />
                    </Box>
                )}

                {arrivalOptions.length > 1 && (
                    <Box between={3}>
                        <Box textSize="m" textWeight="bold">
                            {i18nBlock.arrival()}
                        </Box>
                        <TrainsStationFilter
                            filter={stationToFilter}
                            onChange={onChange}
                        />
                    </Box>
                )}
            </Box>
        );
    };

export default TrainsStationFromAndStationToFilter;
