import {ITrainsSimpleFilterOption} from 'types/trains/search/filters/ITrainsFilters';

import capitalizeFirstLetter from 'utilities/strings/capitalizeFirstLetter';

export function convertFilterOptionToValue<V>(
    option: ITrainsSimpleFilterOption<V>,
): V {
    return option.value;
}

export function convertFilterOptionsToValues(
    options: ITrainsSimpleFilterOption[],
): string[] {
    return options.map(convertFilterOptionToValue);
}

export function convertFilterOptionToText(
    option: ITrainsSimpleFilterOption,
): string {
    return capitalizeFirstLetter(option.text);
}
