import React from 'react';

import {ITrainsGeneralDisclaimersInfo} from 'types/trains/search/disclaimersInfo/ITrainsGeneralDisclaimersInfo';
import {ITrainsFilledSearchContext} from 'reducers/trains/context/types';
import {IWithClassName} from 'types/withClassName';

import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/trains-disclaimers';

import NotificationBanner from 'components/NotificationBanner/NotificationBanner';

interface ITrainsSearchPageHeaderDisclaimersProps extends IWithClassName {
    context: ITrainsFilledSearchContext;
    disclaimersInfo: ITrainsGeneralDisclaimersInfo;
}

const TrainsSearchPageHeaderDisclaimers: React.FC<ITrainsSearchPageHeaderDisclaimersProps> =
    props => {
        const {context, disclaimersInfo, className} = props;

        const disclaimers = [];

        if (!disclaimersInfo.isPurchaseAvailable) {
            disclaimers.push(i18nBlock.purchaseDashDisabled());
        }

        if (disclaimersInfo.isContextChanged && context.original) {
            disclaimers.push(
                i18nBlock.generalization({
                    originFrom: context.original.pointFrom.titleWithType!,
                    originTo: context.original.pointTo.titleWithType!,
                    searchFrom: context.from.titleWithType!,
                    searchTo: context.to.titleWithType!,
                }),
            );
        }

        if (disclaimersInfo.isIncompleteScheduleDisclaimerAvailable) {
            disclaimers.push(i18nBlock.trainDashIncompleteDashSchedule());
        }

        if (disclaimersInfo.areVariantsWithTransfer) {
            disclaimers.push(i18nBlock.noDashDirectDashRoutes());
        }

        if (disclaimers.length === 0) {
            return null;
        }

        return (
            <NotificationBanner
                className={className}
                {...prepareQaAttributes('notificationBanner')}
            >
                {disclaimers}
            </NotificationBanner>
        );
    };

export default React.memo(TrainsSearchPageHeaderDisclaimers);
