import {useCallback, useMemo, FC} from 'react';

import {IWithClassName} from 'types/withClassName';
import {ITrainsFilledSearchContext} from 'reducers/trains/context/types';

import {IDevice} from 'reducers/common/commonReducerTypes';

import {trainsURLs} from 'projects/trains/lib/urls';
import {prepareAndFormatDate} from './utilities/prepareAndFormatDate';

import Link from 'components/Link/Link';
import Intent from 'components/Intent/Intent';

interface ITrainsSearchPageNearestTrainDateProps extends IWithClassName {
    date: string;
    deviceType: IDevice;
    onClick: (date: string) => void;
    context: ITrainsFilledSearchContext;
}

const TrainsSearchPageNearestTrainDate: FC<ITrainsSearchPageNearestTrainDateProps> =
    props => {
        const {className, date, context, onClick, deviceType} = props;

        const handleClick = useCallback(() => {
            onClick(date);
        }, [date, onClick]);

        const searchUrl = useMemo(
            () =>
                trainsURLs.getTrainsSearchUrl({
                    context: {
                        from: context.from.slug,
                        to: context.to.slug,
                        when: date,
                    },
                }),
            [context, date],
        );

        const formattedDate = useMemo(
            () => prepareAndFormatDate({date, deviceType}),
            [date, deviceType],
        );

        return (
            <Link className={className} to={searchUrl}>
                <Intent size="l" text={formattedDate} onClick={handleClick} />
            </Link>
        );
    };

export default TrainsSearchPageNearestTrainDate;
