import moment from 'moment';

import {IDevice} from 'reducers/common/commonReducerTypes';

import {formatDate} from 'utilities/dateUtils';

const DESKTOP_DATE_FORMAT = 'D MMMM, ddd';
const MOBILE_DATE_FORMAT = 'D MMM, ddd';

export const prepareAndFormatDate = ({
    date,
    deviceType,
}: {
    date: string;
    deviceType: IDevice;
}): string => {
    const dateMoment = moment(date);

    return formatDate(
        dateMoment,
        deviceType.isDesktop ? DESKTOP_DATE_FORMAT : MOBILE_DATE_FORMAT,
    );
};
