import {ENearestTrainDatesReason} from 'types/trains/search/searchInfo/INearestTrainDates';

import * as i18nBlock from 'i18n/trains-NearestTrainDates';

export const getNearestTrainDatesTitleByReason = ({
    reason,
}: {
    reason: ENearestTrainDatesReason;
}): string => {
    switch (reason) {
        case ENearestTrainDatesReason.NO_REQUESTED_DATE_TRAINS: {
            return i18nBlock.noTrains();
        }

        case ENearestTrainDatesReason.NO_REQUESTED_DATE_DIRECT_TRAINS: {
            return i18nBlock.noDirectTrains();
        }

        default: {
            return i18nBlock.noTrains();
        }
    }
};
