import React from 'react';

import {IWithDeviceType} from 'types/withDeviceType';

import TrainsSearchPageSegmentSkeletonMobile from './TrainsSearchPageSegmentSkeletonMobile';
import TrainsSearchPageSegmentSkeletonDesktop from './TrainsSearchPageSegmentSkeletonDesktop';

interface ITrainsSearchPageSegmentSkeletonProps extends IWithDeviceType {}

const TrainsSearchPageSegmentSkeleton: React.FC<ITrainsSearchPageSegmentSkeletonProps> =
    ({deviceType}) =>
        deviceType.isMobile ? (
            <TrainsSearchPageSegmentSkeletonMobile />
        ) : (
            <TrainsSearchPageSegmentSkeletonDesktop />
        );

export default TrainsSearchPageSegmentSkeleton;
