import React from 'react';

import {deviceModDesktop} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Box from 'components/Box/Box';
import TextSkeleton from 'components/Skeletons/TextSkeleton/TextSkeleton';
import CardWithDeviceLayout from 'components/CardWithDeviceLayout/CardWithDeviceLayout';

import cx from './TrainsSearchPageSegmentSkeleton.scss';

const TrainsSearchPageSegmentSkeletonDesktop: React.FC = () => {
    const deviceType = useDeviceType();

    return (
        <CardWithDeviceLayout
            className={cx('root', deviceModDesktop('root', deviceType))}
        >
            <div className={cx('overlay')}>
                <div className={cx('point')}>
                    <TextSkeleton className={cx('time')} size="xl" />
                    <TextSkeleton className={cx('stationFirstRow')} size="s" />
                    <TextSkeleton className={cx('stationSecondRow')} size="s" />
                </div>

                <div className={cx('point')}>
                    <TextSkeleton className={cx('time')} size="xl" />
                    <TextSkeleton className={cx('stationFirstRow')} size="s" />
                    <TextSkeleton className={cx('stationSecondRow')} size="s" />
                </div>

                <Box className={cx('additionalInfo')} between={2}>
                    <TextSkeleton className={cx('duration')} size="s" />
                    <TextSkeleton className={cx('info')} size="s" />
                </Box>
            </div>
        </CardWithDeviceLayout>
    );
};

export default TrainsSearchPageSegmentSkeletonDesktop;
