import React from 'react';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceModMobile} from 'utilities/stylesUtils';

import Box from 'components/Box/Box';
import Flex from 'components/Flex/Flex';
import Separator from 'components/Separator/Separator';
import TextSkeleton from 'components/Skeletons/TextSkeleton/TextSkeleton';
import CardWithDeviceLayout from 'components/CardWithDeviceLayout/CardWithDeviceLayout';

import cx from './TrainsSearchPageSegmentSkeleton.scss';

const TrainsSearchPageSegmentSkeletonMobile: React.FC = () => {
    const deviceType = useDeviceType();

    return (
        <CardWithDeviceLayout
            className={cx('root', deviceModMobile('root', deviceType))}
        >
            <div className={cx('overlay')}>
                <Flex justifyContent="space-between">
                    <TextSkeleton className={cx('date')} size="xs" />
                    <TextSkeleton className={cx('date')} size="xs" />
                </Flex>

                <Flex alignItems="center">
                    <TextSkeleton className={cx('time')} size="l" />

                    <Flex
                        className={cx('durationWithSeparators')}
                        alignItems="center"
                        x="2"
                    >
                        <Separator className={cx('separator')} />
                        <TextSkeleton className={cx('duration')} size="xs" />
                        <Separator className={cx('separator')} />
                    </Flex>

                    <TextSkeleton className={cx('time')} size="l" />
                </Flex>

                <Box above={1}>
                    <TextSkeleton className={cx('stations')} size="xs" />
                    <TextSkeleton className={cx('info')} size="xs" />
                </Box>
            </div>
        </CardWithDeviceLayout>
    );
};

export default TrainsSearchPageSegmentSkeletonMobile;
