import React, {useCallback} from 'react';
import {useDispatch} from 'react-redux';

import {IWithClassName} from 'types/withClassName';
import {ESortType} from 'types/common/sort/ESortType';
import {ITrainsSearchSort} from 'projects/trains/lib/sort/types';
import {ESortDirection} from 'types/common/sort/ESortDirection';

import {
    setSorting,
    changeSortReachGoal,
} from 'reducers/trains/search/actions/sorting';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import SortDesktop from 'components/SortDesktop/SortDesktop';

interface ITrainsSearchPageSortProps extends IWithClassName, IWithQaAttributes {
    isFetched: boolean;
    sort: ITrainsSearchSort;
}

const TrainsSearchPageSort: React.FC<ITrainsSearchPageSortProps> = props => {
    const {className, sort, isFetched} = props;

    const dispatch = useDispatch();
    const handleSortChange = useCallback(
        (sortToSet: ITrainsSearchSort) => {
            changeSortReachGoal({sort, sortToSet});

            dispatch(setSorting(sortToSet));
        },
        [dispatch, sort],
    );

    const handleClick = useCallback(
        (sortType: ESortType, sortDirection: ESortDirection) => {
            handleSortChange({
                by: sortType,
                isReverse: sortDirection === ESortDirection.DESC,
            });
        },
        [handleSortChange],
    );

    return (
        <SortDesktop
            className={className}
            type={sort.by}
            loading={!isFetched}
            direction={
                sort.isReverse ? ESortDirection.DESC : ESortDirection.ASC
            }
            onClick={handleClick}
            {...prepareQaAttributes(props)}
        />
    );
};

export default TrainsSearchPageSort;
