import React, {useMemo} from 'react';
import {useSelector} from 'react-redux';

import {ORDER_STEP} from 'projects/trains/constants/orderSteps';

import {EDirection} from 'types/common/EDirection';
import {isFilledTrainsSearchContext} from 'reducers/trains/context/types';
import {
    ETrainsSearchStepType,
    TTrainsOrderStep,
    TTrainsSearchStep,
} from 'types/trains/common/steps/ITrainsSearchAndOrderSteps';
import {ITrainsSearchLocation} from 'types/trains/search/ITrainsSearchLocation';

import {trainsContextSelector} from 'selectors/trains/trainsContextSelector';

import {deviceModDesktop} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {useQueryByLocation} from 'utilities/hooks/useQueryByLocation';
import {PATH_DIRECTION_BY_DIRECTION} from 'projects/trains/lib/urls/pathDirectionHelpers';

import TrainsSearchAndOrderSteps from 'projects/trains/components/TrainsSearchAndOrderSteps/TrainsSearchAndOrderSteps';

import cx from './TrainsSearchPageSteps.scss';

interface ITrainsSearchPageStepsProps {}

const ORDER_STEPS: TTrainsOrderStep[] = [
    {
        type: ORDER_STEP.PLACES,
        isActive: false,
        disabled: true,
        direction: EDirection.FORWARD,
        segmentIndex: 0,
        segmentCount: 1,
    },
    {
        type: ORDER_STEP.PLACES,
        isActive: false,
        disabled: true,
        direction: EDirection.BACKWARD,
        segmentIndex: 0,
        segmentCount: 1,
    },
    {
        type: ORDER_STEP.PASSENGERS,
        isActive: false,
        disabled: true,
    },
    {
        type: ORDER_STEP.CONFIRM,
        isActive: false,
        disabled: true,
    },
    {
        type: ORDER_STEP.PAYMENT,
        isActive: false,
        disabled: true,
    },
];

const TrainsSearchPageSteps: React.FC<ITrainsSearchPageStepsProps> = () => {
    const deviceType = useDeviceType();
    const context = useSelector(trainsContextSelector);
    const {direction}: ITrainsSearchLocation = useQueryByLocation();
    const {returnWhen} = context;

    const searchSteps = useMemo<TTrainsSearchStep[]>(() => {
        const isForwardActive =
            !direction ||
            direction === PATH_DIRECTION_BY_DIRECTION[EDirection.FORWARD];

        const isBackwardActive =
            direction === PATH_DIRECTION_BY_DIRECTION[EDirection.BACKWARD];

        return [
            {
                type: ETrainsSearchStepType.ROUND_TRIP_FORWARD,
                isActive: isForwardActive,
                disabled: false,
            },
            {
                type: ETrainsSearchStepType.ROUND_TRIP_BACKWARD,
                isActive: isBackwardActive,
                disabled: isForwardActive,
            },
        ];
    }, [direction]);

    if (!isFilledTrainsSearchContext(context) || !returnWhen) {
        return null;
    }

    return (
        <TrainsSearchAndOrderSteps
            className={cx('root', deviceModDesktop('root', deviceType))}
            x={deviceType.isMobile ? 4 : 10}
            searchSteps={searchSteps}
            orderSteps={ORDER_STEPS}
        />
    );
};

export default TrainsSearchPageSteps;
