import {ITrainsFilledSearchContext} from 'reducers/trains/context/types';

import {getRouteTitle} from 'projects/trains/lib/meta/getRouteTitle';
import {getRoutePoints} from 'projects/trains/lib/meta/getRoutePoints/getRoutePoints';
import {getRouteHumanFormatDate} from 'projects/trains/lib/meta/getRouteHumanFormatDate/getRouteHumanFormatDate';

import * as i18nBlock from 'i18n/trains-search-page-title';

export const getTrainsSearchPageTitle = ({
    context,
    hasNearestTrainDates,
}: {
    context: ITrainsFilledSearchContext;
    hasNearestTrainDates?: boolean;
}): string => {
    const {returnWhen} = context;
    const points = getRoutePoints(context);
    const humanFormatDate = getRouteHumanFormatDate(context);
    const {titleInflected} = getRouteTitle(points);

    if (humanFormatDate && returnWhen) {
        return i18nBlock.selectTrain({
            routeTitleInflected: titleInflected,
            date: humanFormatDate,
        });
    }

    if (hasNearestTrainDates) {
        return i18nBlock.selectTrainWithTransfer({
            routeTitleInflected: titleInflected,
        });
    }

    return i18nBlock.trainDashDateDashSimple({
        routeTitleInflected: titleInflected,
    });
};
