import React, {useCallback} from 'react';

import {ETrainsGoal} from 'utilities/metrika/types/goals/trains';
import {
    isFilledTrainsSearchContext,
    ITrainsFilledSearchContext,
} from 'reducers/trains/context/types';

import {CHAR_NBSP} from 'utilities/strings/charCodes';
import {humanFormatDate} from 'utilities/dateUtils';
import {reachGoal} from 'utilities/metrika';

import * as i18nBlock from 'i18n/trains-UpdateNotification';

import UpdateNotification from 'projects/trains/components/UpdateNotification/UpdateNotification';

interface ITrainsSearchPageUpdateNotificationProps {
    context: ITrainsFilledSearchContext;
}

const TrainsSearchPageUpdateNotification: React.FC<ITrainsSearchPageUpdateNotificationProps> =
    props => {
        const {context} = props;

        const handleShowUpdateNotification = useCallback(() => {
            reachGoal(ETrainsGoal.SEARCH_EXPIRED);
        }, []);

        const handleUpdateNotification = useCallback(() => {
            reachGoal(ETrainsGoal.SEARCH_EXPIRED_REFRESH_CLICK);
        }, []);

        const handleSkipUpdateNotification = useCallback(() => {
            reachGoal(ETrainsGoal.SEARCH_EXPIRED_CONTINUE);
        }, []);

        const updateNotificationText = isFilledTrainsSearchContext(context)
            ? i18nBlock.textSearch({
                  fromName: `${
                      context.from.popularTitle || context.from.title
                  }${CHAR_NBSP}`,
                  toName: `${CHAR_NBSP}${
                      context.to.popularTitle || context.to.title
                  }`,
                  date: humanFormatDate(context.when),
              })
            : undefined;

        return (
            <UpdateNotification
                text={updateNotificationText}
                primaryActionText={i18nBlock.actionText()}
                onUpdate={handleUpdateNotification}
                onSkip={handleSkipUpdateNotification}
                onShowNotification={handleShowUpdateNotification}
            />
        );
    };

export default TrainsSearchPageUpdateNotification;
