import {useSelector} from 'react-redux';

import {ESearchErrorTypes} from 'projects/trains/lib/search/constants';

import {getTrainsOriginalSearchInfo} from 'selectors/trains/genericSearch/search/getTrainsOriginalSearchInfo';

export const useHasTrainsSearchPageCriticalError = (): boolean => {
    const {errorCode} = useSelector(getTrainsOriginalSearchInfo);

    return Boolean(errorCode) && errorCode !== ESearchErrorTypes.OUT_DATE;
};
