import {useEffect, useRef} from 'react';
import {useSelector} from 'react-redux';

import {EQueryingStatus} from 'types/trains/search/searchInfo/ITrainsSearchInfo';
import {ETrainsGoal} from 'utilities/metrika/types/goals/trains';

import {trainsContextSelector} from 'selectors/trains/trainsContextSelector';
import {trainsBadgesInfoSelector} from 'selectors/trains/genericSearch/badgesInfo/trainsBadgesInfoSelector';
import {getTrainsOriginalSearchInfo} from 'selectors/trains/genericSearch/search/getTrainsOriginalSearchInfo';
import {getTrainsOriginalSearchFilters} from 'selectors/trains/genericSearch/filters/getTrainsOriginalSearchFilters';

import {reachGoal} from 'utilities/metrika';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import reachFiltersGoal from 'projects/trains/lib/metrika/reachFiltersGoal';
import {reachGoalNearestTrainDates} from 'projects/trains/lib/metrika/reachGoalNearestTrainDates';
import {reachGoalVariantWithoutTariffClasses} from 'projects/trains/lib/metrika/reachGoalVariantWithoutTariffClasses';
import {reachGoalVariantNonRefundableBadges} from 'projects/trains/lib/metrika/reachGoalVariantNonRefundableBadges';

export const useTrainsReachGoalsAfterFinishSearchPolling = (): void => {
    const deviceType = useDeviceType();
    const shouldReachGoalsRef = useRef(true);
    const searchContext = useSelector(trainsContextSelector);
    const {status, variants, nearestTrainDatesByDirection} = useSelector(
        getTrainsOriginalSearchInfo,
    );
    const filters = useSelector(getTrainsOriginalSearchFilters);
    const badgesInfo = useSelector(trainsBadgesInfoSelector);

    useEffect(() => {
        if (
            !filters ||
            !shouldReachGoalsRef.current ||
            status !== EQueryingStatus.DONE
        ) {
            return;
        }

        shouldReachGoalsRef.current = false;

        reachGoal(ETrainsGoal.DATE_SEARCH);
        reachFiltersGoal(filters, deviceType.isMobile);
        reachGoalVariantWithoutTariffClasses(variants);
        reachGoalVariantNonRefundableBadges(badgesInfo);
        reachGoalNearestTrainDates({
            searchContext,
            nearestTrainDatesByDirection,
        });
    }, [
        status,
        filters,
        variants,
        badgesInfo,
        deviceType,
        nearestTrainDatesByDirection,
        searchContext,
    ]);

    useEffect(() => {
        if (status === EQueryingStatus.QUERYING) {
            shouldReachGoalsRef.current = true;
        }
    }, [status]);
};
