import {useEffect} from 'react';
import {useDispatch} from 'react-redux';
import {useParams} from 'react-router-dom';

import {
    stopTrainsSearch,
    clearTrainsSearchResult,
} from 'reducers/trains/genericSearch/search/actions';
import {preFetchDataForGenericSearchClient} from 'reducers/trains/genericSearch/search/thunkActions';
import {setSortingFromRequest} from 'reducers/trains/search/actions/sorting';

import {useQueryByLocation} from 'utilities/hooks/useQueryByLocation';
import {getQueryByBrowserHistory} from 'utilities/getQueryByBrowserHistory/getQueryByBrowserHistory';
import getContextFromSearchUrlParams from 'projects/trains/lib/context/getContextFromSearchUrlParams';

interface ITrainsSlugRouterParams {
    fromSlug: string;
    toSlug: string;
}

export const useTrainsSearchPageDataController = (): void => {
    const dispatch = useDispatch();
    const {
        when,
        returnWhen,
        direction,
        forwardSegmentId,
        backwardSegmentId,
        lastSearchTimeMarker,
    } = useQueryByLocation();
    const {fromSlug, toSlug} = useParams<ITrainsSlugRouterParams>();

    /* 1. Update and fill search context */
    useEffect(() => {
        const searchContextByUrlParams = getContextFromSearchUrlParams({
            fromSlug,
            toSlug,
            when,
            returnWhen,
            direction,
            forwardSegmentId,
            backwardSegmentId,
        });

        dispatch(preFetchDataForGenericSearchClient(searchContextByUrlParams));
    }, [
        dispatch,
        fromSlug,
        toSlug,
        when,
        returnWhen,
        direction,
        forwardSegmentId,
        backwardSegmentId,
        lastSearchTimeMarker,
    ]);

    /* 2. Fill sort info after mount page */
    useEffect(() => {
        const queryByBrowserHistory = getQueryByBrowserHistory();

        dispatch(setSortingFromRequest(queryByBrowserHistory));
    }, [dispatch]);

    /* 3. WillUnmount */
    useEffect(() => {
        return (): void => {
            dispatch(stopTrainsSearch());
            dispatch(clearTrainsSearchResult());
        };
    }, [dispatch]);
};
