import {useSelector} from 'react-redux';

import {isFilledTrainsSearchContext} from 'reducers/trains/context/types';
import {EQueryingStatus} from 'types/trains/search/searchInfo/ITrainsSearchInfo';

import {trainsContextSelector} from 'selectors/trains/trainsContextSelector';
import {getTrainsOriginalSearchInfo} from 'selectors/trains/genericSearch/search/getTrainsOriginalSearchInfo';

export const useTrainsSearchPageLoaderState = (): boolean => {
    const searchContext = useSelector(trainsContextSelector);
    const {variants, status, errorCode} = useSelector(
        getTrainsOriginalSearchInfo,
    );

    if (!isFilledTrainsSearchContext(searchContext)) {
        return true;
    }

    if (errorCode) {
        return false;
    }

    if (status === EQueryingStatus.DONE) {
        return false;
    }

    return variants.length === 0;
};
