import {useMemo} from 'react';

import {ITrainsVariant} from 'types/trains/common/variant/ITrainsVariant';
import {ITrainsSearchBadgesInfo} from 'types/trains/search/badgesInfo/ITrainsSearchBadgesInfo';
import {ISearchSegmentBadge} from 'components/SearchSegmentBadges/types/ISearchSegmentBadge';

import {IDevice} from 'reducers/common/commonReducerTypes';

import {getSearchVariantBadges} from 'projects/trains/components/TrainsSearchVariants/components/TrainsSearchVariantBadges/utilities/getSearchVariantBadges';

export const useTrainsSearchVariantBadges = ({
    variant,
    badgesInfo,
    deviceType,
}: {
    variant: ITrainsVariant;
    badgesInfo: ITrainsSearchBadgesInfo;
    deviceType: IDevice;
}): ISearchSegmentBadge[] => {
    return useMemo(
        () =>
            getSearchVariantBadges({
                variant,
                badgesInfo,
                deviceType,
            }),
        [variant, badgesInfo, deviceType],
    );
};
