import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/components';

import SupportPhone from 'components/SupportPhone/SupportPhone';
import Text from 'components/Text/Text';

import cx from './DesktopSupportPhone.scss';

interface IDesktopSupportPhoneProps extends IWithClassName, IWithQaAttributes {}

const DesktopSupportPhone: React.FC<IDesktopSupportPhoneProps> = props => {
    const {className} = props;

    return (
        <Text
            className={cx('root', className)}
            size="m"
            {...prepareQaAttributes(props)}
        >
            {insertJSXIntoKey(i18nBlock.footerDotSupport)({
                phone: (
                    <Text size="inherit" weight="bold">
                        <SupportPhone />
                    </Text>
                ),
            })}
        </Text>
    );
};

export default React.memo(DesktopSupportPhone);
