import React from 'react';
import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';
import ETripImageType from 'projects/trips/components/TripImage/types/ETripImageType';

import Flex from 'components/Flex/Flex';

import TripImage from './TripImage';

export default {
    title: 'Trips/TripImage',
    component: TripImage,
} as Meta;

const ImageDemoLayout: React.FC<{
    type: ETripImageType;
}> = ({type}) => {
    return (
        <Flex
            inset={2}
            flexDirection="column"
            between={4}
            style={{backgroundColor: 'white'}}
        >
            <Flex inline between={2} alignItems="center">
                <TripImage
                    type={type}
                    src="https://avatars.mds.yandex.net/get-travel-hotels/2456341/region_image_213_0/region-desktop"
                />
                <div>Картинка есть и указана верно</div>
            </Flex>
            <Flex inline between={2} alignItems="center">
                <TripImage type={type} src={undefined} />
                <div>Картинка отсутствует</div>
            </Flex>
            <Flex inline between={2} alignItems="center">
                <TripImage type={type} src="wrong_url" />
                <div>Не удалось загрузить картинку</div>
            </Flex>
        </Flex>
    );
};

export const SmallCirceExample: TStorybookFunctionComponent = () => (
    <ImageDemoLayout type={ETripImageType.SMALL_CIRCLE} />
);

SmallCirceExample.parameters = {
    info: {
        comment: 'Вариант 1: небольшая круглая картинка поездки',
    },
};

export const XSmallSquareExample: TStorybookFunctionComponent = () => (
    <ImageDemoLayout type={ETripImageType.X_SMALL_SQUARE} />
);

XSmallSquareExample.parameters = {
    info: {
        comment:
            'Вариант 2: очень маленькая квадратная картинка поездки с фиксированными размерами',
    },
};

export const SmallSquareExample: TStorybookFunctionComponent = () => (
    <ImageDemoLayout type={ETripImageType.SMALL_SQUARE} />
);

SmallSquareExample.parameters = {
    info: {
        comment:
            'Вариант 3: маленькая квадратная картинка поездки с фиксированными размерами',
    },
};

export const LargeSquareExample: TStorybookFunctionComponent = () => (
    <ImageDemoLayout type={ETripImageType.LARGE_SQUARE} />
);

LargeSquareExample.parameters = {
    info: {
        comment:
            'Вариант 4: большая квадратная картинка поездки с фиксированной высотой',
    },
};

export const AutoHeightExample: TStorybookFunctionComponent = () => (
    <ImageDemoLayout type={ETripImageType.AUTO_HEIGHT} />
);

AutoHeightExample.parameters = {
    info: {
        comment: 'Вариант 5: картинка где высота вычисляется от ширины',
    },
};
