import React from 'react';

import ETripImageType from '../types/ETripImageType';
import {IIconProps} from 'icons/types/icon';

import {IDevice} from 'reducers/common/commonReducerTypes';

import NoHotelPhotoS from 'icons/illustrations/NoHotelPhoto/NoHotelPhotoS';
import HotelNoCityPhotoS from 'icons/illustrations/HotelNoCityPhoto/HotelNoCityPhotoS';
import HotelNoCityPhotoL from 'icons/illustrations/HotelNoCityPhoto/HotelNoCityPhotoL';

export default function getStubComponent(
    type: ETripImageType,
    deviceType: IDevice,
): React.ComponentType<IIconProps> {
    switch (type) {
        case ETripImageType.SMALL_CIRCLE:
        case ETripImageType.X_SMALL_SQUARE:
        case ETripImageType.SMALL_SQUARE:
            return NoHotelPhotoS;

        case ETripImageType.LARGE_SQUARE:
        case ETripImageType.AUTO_HEIGHT:
        case ETripImageType.AUTO_HEIGHT_SQUARE:
            return deviceType.isMobile ? HotelNoCityPhotoS : HotelNoCityPhotoL;
    }
}
