import React from 'react';

import {
    EGeoRegionBlockType,
    ISearchFormBlock,
} from 'types/hotels/geoRegion/IGeoRegionInfo';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {useWhiteLabelConfig} from 'utilities/hooks/useWhiteLabelConfig';
import {deviceMods} from 'utilities/stylesUtils';

import SearchFormBlock from 'projects/hotels/pages/GeoRegionPage/components/SearchFormBlock/SearchFormBlock';

import cx from './WhiteLabelSearchFormBlock.scss';

interface IWhiteLabelSearchFormBlockProps {}

const WhiteLabelSearchFormBlock: React.FC<IWhiteLabelSearchFormBlockProps> =
    () => {
        const deviceType = useDeviceType();
        const {config: whiteLabelConfig} = useWhiteLabelConfig();
        const title = whiteLabelConfig?.searchFormTitle ?? '';
        const imageUrl = whiteLabelConfig?.searchFormBg ?? '';

        const block: ISearchFormBlock = {
            type: EGeoRegionBlockType.SEARCH_FORM_BLOCK,
            data: {
                imageUrl,
                title,
                searchFormParams: {
                    isCalendarOpen: false,
                    regionSlug: '',
                },
            },
        };

        return (
            <SearchFormBlock
                className={cx(deviceMods('form', deviceType))}
                deviceType={deviceType}
                block={block}
            />
        );
    };

export default WhiteLabelSearchFormBlock;
