import logo from 'src/images/white-label/s7/s7-logo.png';
import badgeLogo from 'src/images/white-label/s7/s7-badge-logo.png';
import loyaltyLogo from 'src/images/white-label/s7/s7-loyalty-logo.png';
import customerNumberBg from 'src/images/white-label/s7/s7-customer-number-bg.png';
import searchFormBg from 'src/images/white-label/s7/s7-search-form-bg.jpeg';

import {EWhiteLabelPartner} from 'types/common/whiteLabel/EWhiteLabelPartner';
import {IWhiteLabelConfig} from 'types/common/whiteLabel/IWhiteLabelConfig';

import * as i18nBlock from 'i18n/white-label-s7';

const S7_PRIORITY_URL = 'https://www.s7.ru/ru/s7-priority/';

export const WHITE_LABEL_S7_CONFIG: IWhiteLabelConfig = {
    partner: EWhiteLabelPartner.S7,
    logo,
    badgeLogo,
    loyaltyLogo,
    customerNumberBg,
    searchFormBg,
    searchFormTitle: i18nBlock.searchFormTitle(),
    footerBlock: {
        title: i18nBlock.footerLinkBlockTitle(),
        links: [
            {
                name: i18nBlock.loyaltyLinkName(),
                link: S7_PRIORITY_URL,
            },
        ],
    },
    orderLoyaltyDescription: i18nBlock.orderLoyaltyDescription(),
    orderCustomerNumberTitle: i18nBlock.orderCustomerNumberTitle(),
    orderCustomerNumberDescription: i18nBlock.orderCustomerNumberDescription(),
    pointsTooltip: {
        title: i18nBlock.pointsTooltipTitle(),
        text: i18nBlock.pointsTooltipText(),
        link: {
            url: S7_PRIORITY_URL,
            text: i18nBlock.pointsTooltipLinkText(),
        },
    },
};
