export default {
    passport: {
        title: 'Паспорт РФ',
        unused: ['expiration_date'],
        required: ['last_name', 'first_name', 'number'],
        re_validation: {
            first_name: "^[а-яА-Я ']+$",
            last_name: "^[а-яА-Я ']+$",
            middle_name: "^[а-яА-Я ']+$",
            number: '[а-яА-Я]{2}\\d{7}',
        },
    },
    certificate: {
        title: 'Свидетельство о рождении РФ',
        unused: [
            'expiration_date',
            'citizenship',
            'first_name_en',
            'middle_name_en',
            'last_name_en',
        ],
        required: ['last_name', 'first_name', 'number'],
        re_validation: {
            first_name: "^[а-яА-Я ']+$",
            last_name: "^[а-яА-Я ']+$",
            middle_name: "^[а-яА-Я ']+$",
            number: '[а-яА-Я]{2}\\d{7}',
        },
    },
    international: {
        title: 'Заграничный паспорт РФ',
        unused: [
            'citizenship',
            'first_name_en',
            'middle_name_en',
            'last_name_en',
        ],
        required: ['last_name', 'first_name', 'number', 'expiration_date'],
        re_validation: {
            first_name: "^[а-яА-Я ']+$",
            last_name: "^[а-яА-Я ']+$",
            middle_name: "^[а-яА-Я ']+$",
            number: '[а-яА-Я]{2}\\d{7}',
        },
    },
    military: {
        title: 'Военный билет',
        unused: [
            'expiration_date',
            'citizenship',
            'first_name_en',
            'middle_name_en',
            'last_name_en',
        ],
        required: ['last_name', 'first_name', 'number'],
        re_validation: {
            first_name: "^[а-яА-Я ']+$",
            last_name: "^[а-яА-Я ']+$",
            middle_name: "^[а-яА-Я ']+$",
            number: '[а-яА-Я]{2}\\d{7}',
        },
    },
    residence: {
        title: 'Вид на жительство',
        unused: [
            'citizenship',
            'first_name_en',
            'middle_name_en',
            'last_name_en',
        ],
        required: ['last_name', 'first_name', 'number'],
        re_validation: {
            first_name: "^[а-яА-Я ']+$",
            last_name: "^[а-яА-Я ']+$",
            middle_name: "^[а-яА-Я ']+$",
            number: '[а-яА-Я]{2}\\d{7}',
        },
    },
    others: {
        title: 'Иные документы',
        unused: [
            'citizenship',
            'first_name_en',
            'middle_name_en',
            'last_name_en',
        ],
        required: ['last_name', 'first_name', 'number'],
        re_validation: {},
    },
};
