import {ActionType, createReducer} from 'typesafe-actions';

import {IDocTypesProps} from 'reducers/account/docTypes/api-types';

import prepareFetched from './utilities/prepareFetched';

import * as actions from './actions';

const INITIAL_STATE: IDocTypesProps = {
    items: [],
    rules: {},
};

export default createReducer<IDocTypesProps, ActionType<typeof actions>>(
    INITIAL_STATE,
).handleAction(actions.docTypesFetchSuccess, (_, {payload}) =>
    prepareFetched(payload),
);
