import toCamelCase from 'lodash/camelCase';

import {IDocumentTypesDTO} from 'server/api/TravelersApi/types/IDocumentTypesDTO';

import {IDocTypesProps} from 'reducers/account/docTypes/api-types';

import {EDocumentType} from 'server/api/TravelersApi/enums/EDocumentType';

// Don't know what format for this data will be, now working with some mocks
const DOC_WEIGHT = {
    ru_national_passport: 5,
    ru_foreign_passport: 4,
    ru_birth_certificate: 3,
    ru_military_id: 2,
    ru_seaman_passport: 1,
    other: 0,
};

export default (data: IDocumentTypesDTO): IDocTypesProps => {
    const result: IDocTypesProps = {
        items: [],
        rules: {},
    };

    Object.keys(data).forEach(key => {
        result.items.push(key as EDocumentType);

        result.rules[key] = {
            unused: data[key].unused.map(item => toCamelCase(item)),
            required: data[key].required.map(item => toCamelCase(item)),
            validation: {},
        };

        Object.keys(data[key].re_validations).forEach(field => {
            result.rules[key].validation[toCamelCase(field)] =
                data[key].re_validations[field];
        });
    });

    result.items.sort((a, b) => DOC_WEIGHT[b] - DOC_WEIGHT[a]);

    return result;
};
