import {createAction} from 'typesafe-actions';

import {IPassengerDocumentData} from 'types/common/document/IPassengerDocumentData';
import {IPassengerWithDocumentsDTO} from 'server/api/TravelersApi/types/IPassengerDTO';
import {IDocumentDTO} from 'server/api/TravelersApi/types/IDocumentDTO';

export const addDocument = createAction(
    'account/documents/add',
)<IPassengerDocumentData>();

export const addDocumentSuccess = createAction(
    'account/documents/addSuccess',
)<IDocumentDTO>();

export const editDocument = createAction(
    'account/documents/edit',
)<IPassengerDocumentData>();

export const editDocumentSuccess = createAction(
    'account/documents/editSuccess',
)<IDocumentDTO>();

export const removeDocument = createAction(
    'account/documents/remove',
    (id: string, passengerId: string) => ({id, passenger_id: passengerId}),
)();

type TRemoveDocumentSuccessActionParams =
    | {passengerId: string; id?: string}
    | {id: string; passengerId?: string};

export const removeDocumentSuccess = createAction(
    'account/documents/removeSuccess',
)<TRemoveDocumentSuccessActionParams>();

export const processDocument = createAction(
    'account/documents/process',
)<IPassengerDocumentData>();

export const fetchDocumentSuccess = createAction(
    'account/documents/fetchSuccess',
)<IPassengerWithDocumentsDTO[]>();
