import {ActionType, createReducer} from 'typesafe-actions';

import {IPassengerDocumentData} from 'types/common/document/IPassengerDocumentData';

import prepareFetched from './utilities/prepareFetched';

import * as actions from './actions';

type TDocsStore = IPassengerDocumentData[];

const INITIAL_STATE: TDocsStore = [];

export default createReducer<TDocsStore, ActionType<typeof actions>>(
    INITIAL_STATE,
)
    .handleAction(actions.processDocument, (state, action) => {
        if (action.payload.id) {
            return state.map(item => {
                if (item.id === action.payload.id) {
                    return {
                        ...item,
                        ...action.payload,
                        loading: true,
                    };
                }

                return item;
            });
        }

        return [
            ...state,
            {
                ...action.payload,
                id: 'new',
                loading: true,
            },
        ];
    })
    .handleAction(actions.addDocumentSuccess, (state, action) =>
        state.map(item => {
            if (item.id === 'new') {
                return {
                    ...prepareFetched(action.payload),
                    loading: false,
                };
            }

            return item;
        }),
    )
    .handleAction(actions.editDocumentSuccess, (state, action) =>
        state.map(item => {
            if (item.id === action.payload.id) {
                return {
                    ...item,
                    ...prepareFetched(action.payload),
                    loading: false,
                };
            }

            return item;
        }),
    )
    .handleAction(actions.removeDocumentSuccess, (state, action) => {
        if (action.payload.id) {
            return state.filter(item => item.id !== action.payload.id);
        } else if (action.payload.passengerId) {
            return state.filter(
                item => item.passengerId !== action.payload.passengerId,
            );
        }

        return state;
    })
    .handleAction(actions.fetchDocumentSuccess, (_, action) =>
        prepareFetched(action.payload),
    );
