import {ActionType, createAsyncAction} from 'typesafe-actions';

import IGenericOrderGetOrderApiParams from 'server/api/GenericOrderApi/types/getOrder/IGenericOrderGetOrderApiParams';
import {IGenericOrderInfo} from 'server/api/GenericOrderApi/types/common/IGenericOrderInfo';

export const getGenericOrderItemActions = createAsyncAction(
    'ACCOUNT.GENERIC_ORDER.ITEM.REQUEST',
    'ACCOUNT.GENERIC_ORDER.ITEM.REQUEST_SUCCESS',
    'ACCOUNT.GENERIC_ORDER.ITEM.REQUEST_FAILURE',
)<IGenericOrderGetOrderApiParams, IGenericOrderInfo, undefined>();

export type TAccountGenericOrderItemActions = ActionType<
    typeof getGenericOrderItemActions
>;
