import {createReducer} from 'typesafe-actions';

import {EMPTY_ASYNC_STATE} from 'reducers/types/TAsyncStore';
import {TAccountGenericOrderItemStore} from 'reducers/account/genericOrder/item/types';

import {
    getGenericOrderItemActions,
    TAccountGenericOrderItemActions,
} from 'reducers/account/genericOrder/item/actions';

const INITIAL_STATE: TAccountGenericOrderItemStore = EMPTY_ASYNC_STATE;

export default createReducer<
    TAccountGenericOrderItemStore,
    TAccountGenericOrderItemActions
>(INITIAL_STATE)
    .handleAction(getGenericOrderItemActions.request, (state, {payload}) => ({
        ...state,
        value: null,
        requestParams: payload,
        isLoading: true,
        isFetched: false,
        isFailed: false,
        isNotFound: false,
    }))
    .handleAction(getGenericOrderItemActions.success, (state, {payload}) => ({
        ...state,
        value: payload,
        isLoading: false,
        isFetched: true,
        isFailed: false,
        isNotFound: false,
    }))
    .handleAction(getGenericOrderItemActions.failure, state => ({
        ...state,
        value: null,
        isLoading: false,
        isFetched: true,
        isFailed: true,
        isNotFound: false,
    }));
