import isEqual from 'lodash/isEqual';
import {batchActions} from 'redux-batched-actions';

import {FETCH_ORDER_ERROR} from 'constants/errors/orderErrors';

import IGenericOrderGetOrderApiParams from 'server/api/GenericOrderApi/types/getOrder/IGenericOrderGetOrderApiParams';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {getGenericOrderItemActions} from 'reducers/account/genericOrder/item/actions';
import * as actions from 'reducers/account/orders/actions';

import genericOrderItemInfoSelector from 'selectors/account/genericOrder/item/genericOrderItemInfoSelector';

import {logError} from 'utilities/logger/logError';

import {genericOrderBrowserProvider} from 'serviceProvider/genericOrder/genericOrderBrowserProvider';

export default function requestGenericOrderItemAction(
    params: IGenericOrderGetOrderApiParams,
): CustomThunkAction<void> {
    return async (dispatch, getState): Promise<void> => {
        try {
            const state = getState();

            const {requestParams: prevRequestParams} =
                genericOrderItemInfoSelector(state);

            if (isEqual(prevRequestParams, params)) {
                return;
            }

            dispatch(getGenericOrderItemActions.request(params));

            const order = await genericOrderBrowserProvider.getOrder(params);

            dispatch(
                batchActions([
                    getGenericOrderItemActions.success(order),
                    actions.updateOrder.success(order),
                ]),
            );
        } catch (err) {
            dispatch(
                batchActions([
                    getGenericOrderItemActions.failure(),
                    actions.updateOrder.failure(FETCH_ORDER_ERROR),
                ]),
            );

            logError(
                {
                    message:
                        '[YATRAVEL][ACCOUNT] Generic order - загрузка заказа',
                },
                err,
            );
        }
    };
}
