import {ActionType, createAsyncAction} from 'typesafe-actions';

import IGenericOrderCalculateRefundAmountApiResponse from 'server/api/GenericOrderApi/types/calculateRefundAmount/IGenericOrderCalculateRefundAmountApiResponse';
import IRefundPartCtx from 'server/api/GenericOrderApi/types/common/refund/IRefundPartCtx';

export const getGenericOrderRefundAmountInfoActions = createAsyncAction(
    'ACCOUNT.GENERIC_ORDER.REFUND.AMOUNT_INFO.REQUEST',
    'ACCOUNT.GENERIC_ORDER.REFUND.AMOUNT_INFO.REQUEST_SUCCESS',
    'ACCOUNT.GENERIC_ORDER.REFUND.AMOUNT_INFO.REQUEST_FAILURE',
)<IRefundPartCtx[], IGenericOrderCalculateRefundAmountApiResponse, undefined>();

export type TAccountGenericOrderRefundAmountInfoActions = ActionType<
    typeof getGenericOrderRefundAmountInfoActions
>;
