import {createReducer} from 'typesafe-actions';

import {EMPTY_ASYNC_STATE} from 'reducers/types/TAsyncStore';
import {TAccountGenericOrderRefundAmountInfoStore} from 'reducers/account/genericOrder/refund/amountInfo/types';

import {
    getGenericOrderRefundAmountInfoActions,
    TAccountGenericOrderRefundAmountInfoActions,
} from 'reducers/account/genericOrder/refund/amountInfo/actions';

const INITIAL_STATE: TAccountGenericOrderRefundAmountInfoStore =
    EMPTY_ASYNC_STATE;

export default createReducer<
    TAccountGenericOrderRefundAmountInfoStore,
    TAccountGenericOrderRefundAmountInfoActions
>(INITIAL_STATE)
    .handleAction(
        getGenericOrderRefundAmountInfoActions.request,
        (state, {payload}) => ({
            ...state,
            value: null,
            requestParams: payload,
            isLoading: true,
            isFetched: false,
            isFailed: false,
            isNotFound: false,
        }),
    )
    .handleAction(
        getGenericOrderRefundAmountInfoActions.success,
        (state, {payload}) => ({
            ...state,
            value: payload,
            isLoading: false,
            isFetched: true,
            isFailed: false,
            isNotFound: false,
        }),
    )
    .handleAction(getGenericOrderRefundAmountInfoActions.failure, state => ({
        ...state,
        value: null,
        isLoading: false,
        isFetched: true,
        isFailed: true,
        isNotFound: false,
    }));
