import {batchActions} from 'redux-batched-actions';

import {EGenericOrderRefundStatus} from 'reducers/account/genericOrder/refund/status/types';
import {isNotNull} from 'types/utilities';

import {setIsRefundModalOpenedAction} from 'reducers/account/genericOrder/refund/isModalOpened/actions';
import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {setRefundStatusAction} from 'reducers/account/genericOrder/refund/status/actions';

import refundStatusSelector from 'selectors/account/genericOrder/refund/refundStatusSelector';

export default function closeRefundModalAction(): CustomThunkAction<void> {
    return async (dispatch, getState): Promise<void> => {
        const refundStatus = refundStatusSelector(getState());

        dispatch(
            batchActions(
                [
                    setIsRefundModalOpenedAction(false),
                    refundStatus === EGenericOrderRefundStatus.REFUNDING
                        ? null
                        : setRefundStatusAction(
                              EGenericOrderRefundStatus.NOT_STARTED,
                          ),
                ].filter(isNotNull),
            ),
        );
    };
}
