import {createAction, createAsyncAction} from 'typesafe-actions';

import {ORDER_TYPE_VALUES} from 'projects/account/lib/orders/types';
import {IAccountOrdersError} from 'reducers/account/orders/types/IAccountOrdersError';
import IRefundPartCtx from 'server/api/GenericOrderApi/types/common/refund/IRefundPartCtx';
import IGenericOrderCalculateRefundAmountApiResponse from 'server/api/GenericOrderApi/types/calculateRefundAmount/IGenericOrderCalculateRefundAmountApiResponse';
import {IGenericOrderInfo} from 'server/api/GenericOrderApi/types/common/IGenericOrderInfo';
import {ORDER_TRAINS_REGISTRATION_STATUS} from 'projects/account/pages/Order/types/OrderTrainsRegistrationStatus';

export const clearError = createAction('account/orders/clearError')();

export interface IUpdateOrderParams {
    orderId: string;
    trainsOrderType:
        | ORDER_TYPE_VALUES.TRAINS
        | ORDER_TYPE_VALUES.TRAINS_GENERIC;
    isBackground?: boolean;
}
export const updateOrder = createAsyncAction(
    'account/orders/updateOne',
    'account/orders/updateOneSuccess',
    'account/orders/updateOneFailure',
)<IUpdateOrderParams, IGenericOrderInfo, IAccountOrdersError>();

export const orderRegistrationStatusUpdate = createAsyncAction(
    'account/orders/updateRegistrationStatus',
    'account/orders/updateRegistrationStatusSuccess',
    'account/orders/updateRegistrationStatusFailure',
)<
    {
        orderId: string;
        blankIds: string[];
        newStatus: ORDER_TRAINS_REGISTRATION_STATUS;
    },
    IGenericOrderInfo,
    IAccountOrdersError
>();

export const setRefundModalOpenedState = createAction(
    'account/orders/setRefundModalOpenedState',
)<boolean>();

export const setRegistrationModalOpenedState = createAction(
    'account/orders/setRegistrationModalOpenedState',
)<boolean>();

export const setSelectedTickets = createAction(
    'account/orders/setSelectedTickets',
)<string[]>();

export const cancelOrderRefundPoll = createAction(
    'account/orders/cancelOrderRefundPoll',
)();

export interface IAccountOrderOrchestratorRefundAmountRequestParams {
    orderId: string;
    blankIds?: string[];
    refundPartContexts?: IRefundPartCtx[];
}

export const orderRefundAmountRequest = createAction(
    'account/orderOrchestratorRefundAmountRequest',
)<IAccountOrderOrchestratorRefundAmountRequestParams>();

interface IAccountOrderOrchestratorRefundRequestParams {
    orderId: string;
    refundToken: string;
}

export const orderRefund = createAsyncAction(
    'account/orderRefundRequest',
    'account/orderRefundSuccess',
    'account/orderRefundFailure',
)<IAccountOrderOrchestratorRefundRequestParams, never, IAccountOrdersError>();

export const setRefundAmountInfo = createAction(
    'account/setRefundAmountInfo',
)<IGenericOrderCalculateRefundAmountApiResponse>();

export const setRequestedRegistrationStatus = createAction(
    'account/orders/setRequestedRegistrationStatus',
)<ORDER_TRAINS_REGISTRATION_STATUS | null>();
