import {ORDER_TYPE_VALUES} from 'projects/account/lib/orders/types';
import {IOrderWarning} from 'reducers/trains/order/types';

import {
    ORDER_STATUS_VALUES,
    API_TRAINS_STATUSES,
} from 'projects/account/lib/orders/statuses';
import IPrice from 'utilities/currency/PriceInterface';

// PREPARED
export interface IPreparedTrainsOrderUserInfo {
    email: string;
    phone: string;
}

export interface IPreparedTrainsOrderPayment {
    amount: number;
    beddingAmount: number;
    fee: number;
}

export interface IPreparedTrainsOrderTicket {
    amount: number;
    blankId: string;
    rzhdStatus: string | null;
    refund: {amount: number} | null;
    places: string[];
    payment: IPreparedTrainsOrderPayment;
    tariffInfo: {code: string} | null;
    rawTariffTitle: string;
}

export interface IPreparedTrainsOrderPassenger {
    customerId: string;
    tickets: IPreparedTrainsOrderTicket[];
    firstName: string;
    lastName: string;
    patronymic: string;
    // Из ручки списка заказов номер документа не приходит, приходит в подробном заказе
    docId?: string;
    docType: string;
    sex: 'M' | 'F';
    birthDate: string;
    isNonRefundableTariff: boolean;
}

export interface IPreparedTrainsOrderStation {
    id: string;
    title: string;
    popularTitle: string;
    timezone: string;
    settlementTitle?: string;
}

export interface IRefundPayment {
    blankIds: string[];
    paymentRefundReceiptUrl: string;
    refundCreatedAt: string;
    insuranceIds: string[];
    refundPaymentStatus: string;
}

export interface IPreparedTrainsOrder {
    id: string;
    isFuture: boolean;
    type: ORDER_TYPE_VALUES.TRAINS | ORDER_TYPE_VALUES.TRAINS_GENERIC;
    status: ORDER_STATUS_VALUES;
    departure: string;
    arrival: string;
    orderNumber: string;
    partnerOrderNumber?: string;
    trainName?: string;
    trainNumber: string;
    trainTicketNumber?: string;
    travelStatus: API_TRAINS_STATUSES;
    carNumber: string;
    carType: string;
    compartmentGender: string;
    paymentReceiptUrl: string;
    ticketsStatusFreezesAt: string | null;
    isSuburban: boolean;
    stationFrom: IPreparedTrainsOrderStation;
    stationTo: IPreparedTrainsOrderStation;
    // В старых заказах могут не приходить
    startStation?: IPreparedTrainsOrderStation;
    endStation?: IPreparedTrainsOrderStation;
    refundPayments: IRefundPayment[];
    warnings: IOrderWarning[];
    userInfo: IPreparedTrainsOrderUserInfo;
    passengers: IPreparedTrainsOrderPassenger[];
    isOnlyFullReturnPossible: boolean;
    refundAmount: IPrice | null;
    refundToken: string | null;
}
