import {createAction} from 'typesafe-actions';

import {IPassengerWithDocumentsAndBonusCardsDTO} from 'server/api/TravelersApi/types/IPassengerDTO';

import {IPreparedPassenger} from 'reducers/account/passengers/api-types';

import TDataAddPassenger from 'utilities/passengerApiMethods/TDataAddPassenger';

export const processPassenger = createAction(
    'account/passenger/process',
)<void>();

export const fetchPassenger = createAction(
    'account/passenger/fetchAll',
)<void>();

export const fetchPassengerSuccess = createAction(
    'account/passenger/fetchSuccess',
)<IPassengerWithDocumentsAndBonusCardsDTO[]>();

export const addPassenger = createAction(
    'account/passenger/add',
)<TDataAddPassenger>();

export const addPassengerSuccess = createAction(
    'account/passenger/addSuccess',
)<IPassengerWithDocumentsAndBonusCardsDTO>();

export const editPassenger = createAction(
    'account/passenger/edit',
)<IPreparedPassenger>();

export const editPassengerSuccess = createAction(
    'account/passenger/editSuccess',
)<IPassengerWithDocumentsAndBonusCardsDTO>();

export const removePassenger = createAction('account/passenger/remove')<{
    id: string;
}>();

export const removePassengerSuccess = createAction(
    'account/passenger/removeSuccess',
)<{id: string}>();

export const redirectedToJustAdded = createAction(
    'account/passenger/redirected',
)<void>();

export const failPassenger = createAction('account/passenger/fail')<void>();

export const authErrorPassenger = createAction(
    'account/passenger/authError',
)<void>();
