import {IPassengerWithDocumentsAndBonusCardsDTO} from 'server/api/TravelersApi/types/IPassengerDTO';

import {IPreparedPassenger} from 'reducers/account/passengers/api-types';
import prepareFetchedItem from 'reducers/account/passengers/utilities/prepareFetchedItem';

function prepareFetched(
    data: IPassengerWithDocumentsAndBonusCardsDTO,
): IPreparedPassenger;
function prepareFetched(
    data: IPassengerWithDocumentsAndBonusCardsDTO[],
): IPreparedPassenger[];
function prepareFetched(
    data:
        | IPassengerWithDocumentsAndBonusCardsDTO
        | IPassengerWithDocumentsAndBonusCardsDTO[] = [],
): IPreparedPassenger | IPreparedPassenger[] {
    if (Array.isArray(data)) {
        return data.map(item => prepareFetchedItem(item));
    }

    return prepareFetchedItem(data);
}

export default prepareFetched;
