import {IPassengerWithDocumentsAndBonusCardsDTO} from 'server/api/TravelersApi/types/IPassengerDTO';

import {IPreparedPassenger} from 'reducers/account/passengers/api-types';

import {formatDate} from 'utilities/dateUtils';
import {HUMAN_DATE_RU} from 'utilities/dateUtils/formats';

const prepareFetchedItem = (
    item: IPassengerWithDocumentsAndBonusCardsDTO,
): IPreparedPassenger => ({
    id: item.id,
    title: item.title,
    gender: item.gender,
    birthDate: formatDate(item.birth_date, HUMAN_DATE_RU),
    itn: item.itn ?? undefined,
    email: item.email ?? undefined,
    phone: item.phone ?? undefined,
    train_notifications_enabled: Boolean(item.train_notifications_enabled),
});

export default prepareFetchedItem;
