import {TAviaFlightStore} from 'reducers/avia/flight/types';
import {IAviaSearchFormValues} from 'projects/avia/components/SearchForm/types';
import ICountryRestrictionsInfo from 'components/CountryRestrictions/types/ICountryRestrictionsInfo';

import {IAviaContext, IAviaPointsData} from 'reducers/avia/data-types';
import {IAviaPage} from 'reducers/avia/page/reducer';
import {ICalendarPricesStateType} from 'reducers/avia/aviaCalendarPrices/reducer';
import {AviaBookingStateType} from 'reducers/avia/booking/reducer';
import {IAviaSearchReducer} from 'reducers/avia/search/IAviaSearchReducer';
import {IAviaVariantOrder} from 'reducers/avia/order/reducer';
import {IAviaRedirectPageData} from 'reducers/avia/redirect/reducer';
import {TAviaPriceIndexStateType} from 'reducers/avia/aviaPriceIndex/reducer';
import {IAviaFeaturesFlags} from 'reducers/avia/featuresFlags/actions';
import {IPlatformState} from 'reducers/avia/platform/reducer';
import {IAviaRouteStore} from 'reducers/avia/route/reducer';
import {IAviaSearchSuggestsStore} from 'reducers/avia/searchSuggests/reducer';
import {IAviaLogMetricsState} from 'reducers/avia/aviaLogMetrics/reducer';
import {IAviaPersonalization} from 'reducers/avia/personalization/reducer';
import {IAviaFlightsToStore} from 'reducers/avia/flightsTo/reducer';
import {IAviaSearchToCountryState} from 'reducers/avia/searchToCountry/reducer';
import {IAviaSearchToAnywhereState} from 'reducers/avia/searchToAnywhere/reducer';
import {IAviaWeatherForecastState} from 'reducers/avia/weatherForecast/reducer';

export interface IAviaStore {
    searchForm: IAviaSearchFormValues;
    searchSuggests: IAviaSearchSuggestsStore;
    page: IAviaPage;
    aviaContext: IAviaContext;
    aviaCalendarPrices: ICalendarPricesStateType;
    aviaBooking: AviaBookingStateType;
    aviaSearch: IAviaSearchReducer;
    aviaOrder: IAviaVariantOrder;
    aviaPointsData: IAviaPointsData;
    aviaRedirect: IAviaRedirectPageData;
    aviaPriceIndex: TAviaPriceIndexStateType;
    aviaFeaturesFlags: IAviaFeaturesFlags;
    aviaPlatform: IPlatformState;
    aviaRoute: IAviaRouteStore;
    aviaFlightsTo: IAviaFlightsToStore;
    flight: TAviaFlightStore;
    aviaLogMetrics: IAviaLogMetricsState;
    personalization: IAviaPersonalization;
    countryRestrictions: ICountryRestrictionsInfo;
    searchToCountry: IAviaSearchToCountryState;
    searchToAnywhere: IAviaSearchToAnywhereState;
    weatherForecast: IAviaWeatherForecastState;
}
