import {createAction, createAsyncAction} from 'typesafe-actions';

import {ECalendarType} from 'components/Calendar/types';
import {TCalendarPrices} from 'types/common/calendarPrice/ICalendarPrice';

export const {
    request: fetchCalendarPrices,
    success: receiveCalendarPrices,
    failure: calendarPricesFailure,
} = createAsyncAction(
    'avia/aviaCalendarPrices/fetch',
    'avia/aviaCalendarPrices/fetchSuccess',
    'avia/aviaCalendarPrices/fetchError',
)<ECalendarType, {prices: TCalendarPrices}, {error: any}>();

export const resetCalendarPrices = createAction(
    'avia/aviaCalendarPrices/reset',
)();
