import {createReducer, ActionType} from 'typesafe-actions';

import {TCalendarPrices} from 'types/common/calendarPrice/ICalendarPrice';

import * as actions from 'reducers/avia/aviaCalendarPrices/actions';
import {RemoteResourceStatus} from 'reducers/avia/data-types';

export interface ICalendarPricesStateType {
    status: RemoteResourceStatus;
    prices: TCalendarPrices;
}

const initialState: ICalendarPricesStateType = {
    status: 'INIT',
    prices: {},
};

export default createReducer<
    ICalendarPricesStateType,
    ActionType<typeof actions>
>(initialState)
    .handleAction(actions.fetchCalendarPrices, state => ({
        ...state,
        status: 'FETCHING',
    }))
    .handleAction(actions.receiveCalendarPrices, (state, {payload}) => ({
        ...state,
        status: 'READY',
        prices: payload.prices,
    }))
    .handleAction(actions.calendarPricesFailure, state => ({
        ...state,
        status: 'ERROR',
    }))
    .handleAction(actions.resetCalendarPrices, () => initialState);
