import {createReducer} from 'typesafe-actions';

import {EHistoryControlType} from 'server/loggers/avia/AviaActionLog/types/EHistoryControlType';

import {TAviaActions} from '../reducer';
import {
    incrementSearchFormChangesAction,
    resetAviaLogMetricsAction,
    setHistoryControlUsedAction,
} from './actions';

export interface IAviaLogMetricsState {
    changesCount: number;
    changesCountAfterSuggest: number;
    historyUseType: EHistoryControlType | undefined;
}

const initialState: IAviaLogMetricsState = {
    changesCount: 0,
    changesCountAfterSuggest: 0,
    historyUseType: undefined,
};

export default createReducer<IAviaLogMetricsState, TAviaActions>(initialState)
    .handleAction(incrementSearchFormChangesAction, state => ({
        ...state,
        changesCount: state.changesCount + 1,
        changesCountAfterSuggest:
            state.historyUseType === EHistoryControlType.SUGGEST
                ? state.changesCountAfterSuggest + 1
                : state.changesCountAfterSuggest,
    }))
    .handleAction(setHistoryControlUsedAction, (state, action) => ({
        ...state,
        historyUseType: action.payload.type,
    }))
    .handleAction(resetAviaLogMetricsAction, () => initialState);
